/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.history;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.history.VWHistoryTableModel;
import filenet.vw.toolkit.runtime.step.core.history.VWRowItemRenderer;
import filenet.vw.toolkit.runtime.step.core.history.images.VWImageLoader;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWExpandButtonEditor;
import filenet.vw.toolkit.utils.table.VWExpandButtonRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class VWHistoryDialog
extends VWModalDialog
implements ActionListener,
IVWFrameInterface {
    private static final int WIDTH = 600;
    private static final int HEIGHT = 400;
    private Frame m_parentFrame = null;
    private VWStepElement m_vwStepElement = null;
    private VWProcess m_vwProcess = null;
    private VWWorkflowDefinition m_vwWorkflowDefinition = null;
    private JComboBox m_mapNameCombo = null;
    private VWTable m_table = null;
    private VWHistoryTableModel m_tableModel = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;

    public VWHistoryDialog(Frame parentFrame, VWStepElement vwStepElement) {
        super(parentFrame);
        this.m_parentFrame = parentFrame;
        this.m_vwStepElement = vwStepElement;
        try {
            this.m_vwProcess = vwStepElement.fetchProcess();
            this.m_vwWorkflowDefinition = this.m_vwProcess.fetchWorkflowDefinition(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            String message = ex.getLocalizedMessage();
            if (message == null || message != null && message.length() == 0) {
                message = ex.toString();
            }
            JOptionPane.showMessageDialog(this.m_parentFrame, message, VWResource.s_error, 0);
        }
        this.createControls();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_mapNameCombo)) {
            String mapName;
            if (this.m_tableModel != null && (mapName = (String)this.m_mapNameCombo.getSelectedItem()) != null) {
                int[] mapIds = null;
                try {
                    if (VWStringUtils.compare(mapName, VWResource.s_all) == 0) {
                        int nMapCount = this.m_mapNameCombo.getItemCount();
                        if (nMapCount > 1) {
                            mapIds = new int[nMapCount - 1];
                            for (int i = 1; i < nMapCount; ++i) {
                                VWMapDefinition map = this.m_vwWorkflowDefinition.getMap((String)this.m_mapNameCombo.getItemAt(i));
                                mapIds[i - 1] = map.getMapId();
                            }
                        }
                    } else {
                        mapIds = new int[1];
                        VWMapDefinition map = this.m_vwWorkflowDefinition.getMap(mapName);
                        mapIds[0] = map.getMapId();
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    String message = ex.getLocalizedMessage();
                    if (message == null || message != null && message.length() == 0) {
                        message = ex.toString();
                    }
                    JOptionPane.showMessageDialog(this.m_parentFrame, message, VWResource.s_error, 0);
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_tableModel.setMapIds(mapIds);
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (source.equals(this.m_closeButton)) {
            this.windowClosing(null);
        } else if (source.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfsp020.htm");
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    private void createControls() {
        try {
            this.setTitle(VWResource.s_workflowHistoryDialogTitle);
            this.setSize(600, 400);
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            JPanel panel = this.getTopPanel();
            if (panel != null) {
                this.getContentPane().add((Component)panel, "First");
            }
            if ((panel = this.getMainPanel()) != null) {
                this.getContentPane().add((Component)panel, "Center");
            }
            if ((panel = this.getButtonPanel()) != null) {
                this.getContentPane().add((Component)panel, "Last");
            }
            if (this.m_mapNameCombo != null && this.m_mapNameCombo.getItemCount() > 0) {
                this.m_mapNameCombo.setSelectedItem(this.m_vwStepElement.getCurrentMapName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getTopPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            if (this.m_vwStepElement != null && this.m_vwWorkflowDefinition != null) {
                GridBagConstraints gbCons = new GridBagConstraints();
                gbCons.gridx = 0;
                gbCons.gridy = 0;
                gbCons.gridwidth = 1;
                gbCons.gridheight = 1;
                gbCons.weightx = 0.0;
                gbCons.weighty = 0.0;
                gbCons.anchor = 21;
                gbCons.fill = 0;
                gbCons.insets = new Insets(0, 5, 0, 5);
                gbCons.ipadx = 0;
                gbCons.ipady = 0;
                JLabel label = new JLabel(VWResource.s_colon.toString(VWResource.s_subject));
                panel.add((Component)label, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 0.8;
                gbCons.fill = 2;
                JTextField textField = new JTextField(this.m_vwStepElement.getSubject());
                textField.setEditable(false);
                textField.setBackground(this.getBackground());
                panel.add((Component)textField, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 0.0;
                gbCons.fill = 0;
                label = new JLabel(VWResource.s_colon.toString(VWResource.s_map) + "  ");
                panel.add((Component)label, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 0.2;
                gbCons.fill = 2;
                VWMapDefinition[] maps = this.m_vwWorkflowDefinition.getMaps();
                if (maps != null && maps.length > 0) {
                    Vector<String> names = new Vector<String>();
                    names.addElement(VWResource.s_all);
                    for (int nIndex = 0; nIndex < maps.length; ++nIndex) {
                        names.addElement(maps[nIndex].getName());
                    }
                    this.m_mapNameCombo = new JComboBox(names);
                    this.m_mapNameCombo.addActionListener(this);
                    panel.add((Component)this.m_mapNameCombo, gbCons);
                }
            }
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getMainPanel() {
        try {
            JPanel panel = new JPanel(new BorderLayout());
            VWRowItemRenderer renderer = new VWRowItemRenderer();
            this.m_tableModel = new VWHistoryTableModel(this.m_vwStepElement.fetchProcess());
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setRowSelectionAllowed(false);
            TableColumn column = this.m_table.getColumnModel().getColumn(0);
            if (column != null) {
                column.setMinWidth(15);
                column.setMaxWidth(15);
                column.setCellEditor(new VWExpandButtonEditor(new JButton()));
                column.setCellRenderer(new VWExpandButtonRenderer());
            }
            if ((column = this.m_table.getColumnModel().getColumn(1)) != null) {
                column.setCellRenderer(renderer);
            }
            if ((column = this.m_table.getColumnModel().getColumn(2)) != null) {
                column.setMaxWidth(30);
                column.setMinWidth(30);
                column.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("occurrence.gif"), VWResource.s_occurrence));
                column.setCellRenderer(renderer);
            }
            if ((column = this.m_table.getColumnModel().getColumn(3)) != null) {
                column.setCellRenderer(renderer);
            }
            if ((column = this.m_table.getColumnModel().getColumn(4)) != null) {
                column.setCellRenderer(renderer);
            }
            if ((column = this.m_table.getColumnModel().getColumn(5)) != null) {
                column.setCellRenderer(renderer);
            }
            if ((column = this.m_table.getColumnModel().getColumn(6)) != null) {
                column.setCellRenderer(renderer);
            }
            panel.add((Component)new JScrollPane(this.m_table), "Center");
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel(new FlowLayout());
            this.m_closeButton = new JButton(VWResource.s_close);
            panel.add(this.m_closeButton);
            this.m_closeButton.addActionListener(this);
            this.m_helpButton = new JButton(VWResource.s_helpDots);
            panel.add(this.m_helpButton);
            this.m_helpButton.addActionListener(this);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

